/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.configuration.variables.ConfigVar;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchguard.configuration.variables.EncryptionException;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;

public class ConfigVarApi {
    public static final RestApi REST_API = new RestApi().handlesGet("/_searchguard/config/vars").with((Action)GetAllAction.INSTANCE).handlesGet("/_searchguard/config/vars/{id}").with((Action)GetAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).handlesPut("/_searchguard/config/vars").with((Action)UpdateAllAction.INSTANCE).handlesPut("/_searchguard/config/vars/{id}").with((Action)UpdateAction.INSTANCE, (params, body) -> new UpdateAction.Request((String)params.get("id"), body)).handlesDelete("/_searchguard/config/vars/{id}").with((Action)DeleteAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).name("/_searchguard/config/vars");

    public static class UpdateAllAction
    extends Action<Request, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(UpdateAllAction.class);
        public static final UpdateAllAction INSTANCE = new UpdateAllAction();
        public static final String NAME = "cluster:admin:searchguard:config/vars/put/all";

        protected UpdateAllAction() {
            super(NAME, Request::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<Request, StandardResponse> {
            private ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configVarService = configVarService;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.configVarService.updateAll(request.getIdToValueMap());
            }
        }

        public static class Request
        extends Action.Request {
            private Map<String, ConfigVar> idToValueMap;

            public Request(Map<String, ConfigVar> idToValueMap) {
                this.idToValueMap = idToValueMap;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                ImmutableMap map = message.requiredDocNode().toMap();
                ValidationErrors validationErrors = new ValidationErrors();
                this.idToValueMap = new HashMap<String, ConfigVar>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        this.idToValueMap.put((String)entry.getKey(), new ConfigVar(DocNode.wrap(entry.getValue())));
                    }
                    catch (ConfigValidationException e) {
                        validationErrors.add((String)entry.getKey(), e);
                    }
                }
            }

            public Object toBasicObject() {
                return this.idToValueMap;
            }

            public Map<String, ConfigVar> getIdToValueMap() {
                return this.idToValueMap;
            }
        }
    }

    public static class GetAllAction
    extends Action<StandardRequests.EmptyRequest, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(GetAllAction.class);
        public static final GetAllAction INSTANCE = new GetAllAction();
        public static final String NAME = "cluster:admin:searchguard:config/vars/get/all";

        protected GetAllAction() {
            super(NAME, StandardRequests.EmptyRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.EmptyRequest, StandardResponse> {
            private ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configVarService = configVarService;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.EmptyRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        return new StandardResponse(200).data(this.configVarService.getAllFromIndex());
                    }
                    catch (Exception e) {
                        log.error("Error in GetAllAction", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }
    }

    public static class DeleteAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(DeleteAction.class);
        public static final DeleteAction INSTANCE = new DeleteAction();
        public static final String NAME = "cluster:admin:searchguard:config/vars/delete";

        protected DeleteAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configVarService = configVarService;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.configVarService.delete(request.getId());
            }
        }
    }

    public static class UpdateAction
    extends Action<Request, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(UpdateAction.class);
        public static final UpdateAction INSTANCE = new UpdateAction();
        public static final String NAME = "cluster:admin:searchguard:config/vars/put";

        protected UpdateAction() {
            super(NAME, Request::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<Request, StandardResponse> {
            private ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configVarService = configVarService;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                try {
                    return this.configVarService.update(request);
                }
                catch (EncryptionException e) {
                    log.error("Error while encrypting data: " + (Object)((Object)request), (Throwable)e);
                    return CompletableFuture.completedFuture(new StandardResponse(500, e.getMessage()));
                }
            }
        }

        public static class Request
        extends Action.Request {
            private final String id;
            private final Object value;
            private final String scope;
            private final boolean encrypt;

            public Request(String id, Object value, String scope, boolean encrypt) {
                this.id = id;
                this.value = value;
                this.scope = scope;
                this.encrypt = encrypt;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                DocNode docNode = message.requiredDocNode();
                this.id = docNode.getAsString("id");
                this.value = docNode.get("value");
                this.scope = docNode.getAsString("scope");
                this.encrypt = docNode.getBoolean("encrypt");
            }

            public Request(String id, UnparsedDocument<?> doc) throws ConfigValidationException {
                ValidationErrors validationErrors = new ValidationErrors();
                ValidatingDocNode vNode = new ValidatingDocNode(doc.parseAsDocNode(), validationErrors);
                this.id = id;
                this.value = vNode.get("value").required().asAnything();
                this.scope = vNode.get("scope").asString();
                this.encrypt = vNode.get("encrypt").withDefault(false).asBoolean();
            }

            public Object toBasicObject() {
                return ImmutableMap.ofNonNull((Object)"id", (Object)this.id, (Object)"value", (Object)this.value, (Object)"scope", (Object)this.scope, (Object)"encrypt", (Object)this.encrypt);
            }

            public String getId() {
                return this.id;
            }

            public Object getValue() {
                return this.value;
            }

            public String getScope() {
                return this.scope;
            }

            public boolean isEncrypt() {
                return this.encrypt;
            }
        }
    }

    public static class GetAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(GetAction.class);
        public static final GetAction INSTANCE = new GetAction();
        public static final String NAME = "cluster:admin:searchguard:config/vars/get";

        protected GetAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private ConfigVarService configVarService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigVarService configVarService) {
                super((Action)INSTANCE, handlerDependencies);
                this.configVarService = configVarService;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        ConfigVar value = this.configVarService.getFromIndex(request.getId());
                        if (value != null) {
                            return new StandardResponse(200).data(value.toBasicObject());
                        }
                        return new StandardResponse(404).error("Not found");
                    }
                    catch (Exception e) {
                        log.error("Error in GetAction", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }
    }
}

